/*
 *  linux/arch/arm/mach-uniphier/include/mach/uncompress.h
 *
 *  Copyright (C) 2011 Panasonic Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef __ASM_ARCH_UNCOMPRESS_H
#define __ASM_ARCH_UNCOMPRESS_H

#include <linux/serial_reg.h>
#include <mach/serial.h>

#ifndef CONFIG_UNIPHIER_DEFAULT_BAUDRATE
#define CONFIG_UNIPHIER_DEFAULT_BAUDRATE	115200
#endif /* CONFIG_UNIPHIER_DEFAULT_BAUDRATE */


static void
putc(int c)
{
#if defined(CONFIG_UNIPHIER_UART) || defined(CONFIG_SC_UART)
	unsigned long base = UNIPHIER_UART_PHYS_ADDR;

	while (!(__raw_readb(base + (UNIPHIER_UART_LSR << UNIPHIER_UART_REG_SHIFT))
		 & UART_LSR_TEMT));
	__raw_writeb((char)c, base + (UNIPHIER_UART_TX << UNIPHIER_UART_REG_SHIFT));
#endif /* CONFIG_UNIPHIER_UART || CONFIG_SC_UART */
}


static inline void flush(void)
{
}

static void
arch_decomp_setup(void)
{
#if defined(CONFIG_UNIPHIER_UART) || defined(CONFIG_SC_UART)
	unsigned long cval;
	unsigned long quot;
	unsigned long base = UNIPHIER_UART_PHYS_ADDR;

	quot = UNIPHIER_UART_BASE_BAUD / CONFIG_UNIPHIER_DEFAULT_BAUDRATE;
	cval = UNIPHIER_UART_LCR_WLEN8;

#ifdef CONFIG_UNIPHIER_UART
	__raw_writel(cval,
		base + (UNIPHIER_UART_LCR << UNIPHIER_UART_REG_SHIFT));
	__raw_writel(0,
		base + (UNIPHIER_UART_FCR << UNIPHIER_UART_REG_SHIFT));	/* disable FIFO */
	__raw_writel(quot,
		base + (UNIPHIER_UART_DLL << UNIPHIER_UART_REG_SHIFT));	/* divisor */
	__raw_writel(0,
		base + (UNIPHIER_UART_IER << UNIPHIER_UART_REG_SHIFT));	/* disable interrupt */

#else /* CONFIG_UNIPHIER_UART */
	__raw_writeb(0,
		base + (UART_FCR << UNIPHIER_UART_REG_SHIFT));	/* disable FIFO */
	__raw_writeb((cval | UART_LCR_DLAB),
		base + (UART_LCR << UNIPHIER_UART_REG_SHIFT));	/* set DLAB */
	__raw_writeb((quot & 0xff),
		base + (UART_DLL << UNIPHIER_UART_REG_SHIFT));	/* LS of divisor */
	__raw_writeb((quot >> 8),
		base + (UART_DLM << UNIPHIER_UART_REG_SHIFT));	/* MS of divisor */
	__raw_writeb(cval,
		base + (UART_LCR << UNIPHIER_UART_REG_SHIFT));	/* reset DLAB */
	__raw_writeb(0,
		base + (UART_IER << UNIPHIER_UART_REG_SHIFT));	/* disable interrupt */

#endif /* CONFIG_UNIPHIER_UART */
#endif /* CONFIG_UNIPHIER_UART || CONFIG_SC_UART */
}

#define arch_decomp_wdog()

#endif
